k6 v0.36.0 is here! 🎉 It introduces a couple of new features which enhance its usability, includes a number of fixes, and the result of ongoing refactoring efforts.

## New Features!

### Source Maps support ([#2082](https://github.com/grafana/k6/pull/2082))

Following [#2082](https://github.com/grafana/k6/pull/2082), k6 now has support for [Source Maps](https://developer.mozilla.org/en-US/docs/Tools/Debugger/How_to/Use_a_source_map). k6 will try to load source maps either from the file system(s) or from inside the script, based on the standard(-ish) `//#sourceMappingURL=` comments. Furthermore, as k6 internally uses Babel to transform ES6+ scripts to ES5.1+, it will now make use of its ability to generate source maps, including combining with previously generated ones, to report correct line numbers. This should fix [#1804](https://github.com/grafana/k6/issues/1804); however, we anticipate some more issues will arise, and further tweaking will be necessary.

Thus, given an `imported.js` module such as:
```javascript
export function f1() {
  throw "line 2";
}

  throw "line 6";
}

export function f3() {
  throw "line 10";
}
```

and a k6 test script importing it as such:
```javascript
import { f2 } from "./imported.js"

export default function() {
  f2();
}
```

Previous versions of k6 would report an error stack trace indicating an invalid line number in `imported.js` (10):
```
ERRO[0000] line 6
        at f2 (file:///some/path/imported.js:10:61(2))
        at file:///some/path/sourcemap.js:4:20(4) executor=per-vu-iterations scenario=default source=stacktrace
```

Starting with `v0.36.0` and source maps support, k6 would now report the exception at the correct line in `imported.js`:
```
ERRO[0000] line 6
        at f2 (file:///some/path/imported.js:6:2(2))
        at file:///some/path/loadtest.js:4:2(4)
        at native executor=per-vu-iterations scenario=default source=stacktrace
```

#### Temporary warning

Note that if a file size is greater than **250kb** and the internal Babel is needed, Babel will not generate source map. This is because during internal testing it was found this takes *3x* to *4x* more memory, potentially leading to OOM (standing for "Out Of Memory", a state in which the OS kills a process for using too much memory) on bigger inputs. If required, you can control the accepted file size limit via the temporary `K6_DEBUG_SOURCEMAP_FILESIZE_LIMIT=524288` environment variable; which will be removed after we no longer rely on Babel ([#2296](https://github.com/grafana/k6/issues/2296)). A pre-generated source map will always be loaded. For more details, check [#2345](https://github.com/grafana/k6/pull/2345).

### Ability to abort tests ([#2093](https://github.com/grafana/k6/pull/2093))

Thanks to the contribution of @gernest ([#2093](https://github.com/grafana/k6/pull/2093)), k6 now has the ability to abort a test run from within the test script. The newly added `test.abort()` function in the [`k6/execution` module](https://k6.io/docs/javascript-api/k6-execution/) allows k6 scripts to immediately abort the test execution - the VU that called it will abort immediately and any other VUs in the same or other instances (in the case of `k6 cloud`) will also be interrupted and abort soon after. Local `k6 run` tests will exit with a code of `108`, so this event can also be easily detected in a CI script. 

Aborting is possible during initialization:
```javascript
import exec from "k6/execution";
exec.test.abort();
```

As well as inside the default function:
```javascript
import exec from "k6/execution";

export default function() {
  // Note that you can abort with a specific message too
  exec.test.abort("this is the reason");
}

export function teardown() {
  console.log("teardown will still be called after test.abort()");
}
```

### k6 inspect extended output ([#2279](https://github.com/grafana/k6/pull/2279))

Following [#2279](https://github.com/grafana/k6/pull/2279), the `k6 inspect` command now supports an `--execution-requirements` flag. When used, the command's output will include fields related to the execution requirements, by deriving k6's configuration from the execution context, and including the `maxVUs` and `totalDuration` fields in the output.


### Forcing HTTP/1 protocol ([#2222](https://github.com/grafana/k6/pull/2222))

Thanks to the work of @sjordhani22, [#2222](https://github.com/grafana/k6/pull/2222) made it possible to force k6 to use version 1.1 of the protocol when firing HTTP requests. 

It can be done by setting the `http2client=0` value in the `GODEBUG` environment variable:

```
GODEBUG=http2client=0 k6 run testscript.js
```

**N.B**: the usage of the `GODEBUG` variable is considered temporary, and expected to change in the future. If you start using this feature, keep an eye out for potential future changes.

## Extensions

`v0.36.0` marks the switch of some of our internal modules to [a new Go/JavaScript module API](https://k6.io/docs/extensions/guides/create-an-extension/#advanced-javascript-extension). We expect this change to make the process of developing internal JavaScript modules and advanced JavaScript extensions easier and more streamlined in the future. Although this switch to a new API does not introduce breaking changes for existing extensions yet, we anticipate deprecating the old extension API (e.g. `common.Bind()`, `lib.WithState()`, etc.) at an undecided point in the future.

For more details, see: [#2243](https://github.com/grafana/k6/pull/2243), [#2241](https://github.com/grafana/k6/pull/2241), [#2239](https://github.com/grafana/k6/pull/2239), [#2242](https://github.com/grafana/k6/pull/2242), [#2226](https://github.com/grafana/k6/pull/2226), and [#2232](https://github.com/grafana/k6/pull/2232).

## Breaking changes

### Restricting file opening to init context

VUs are now restricted to only `open()` files that were also opened in the [init context](https://k6.io/docs/using-k6/test-life-cycle/#init-and-vu-stages) of the first VU - the one that was initialized to get the exported `options` from the JS script (`__VU==0`). While it was somewhat possible to open files *only* in other *VUs* (*e.g* `__VU==2`) in the past, it was [unreliable](https://github.com/grafana/k6/issues/1771). [#2314](https://github.com/grafana/k6/pull/2314) ensures that k6 would now throw an error in a similar scenario. This means that you can still open files only for some VUs, but you need to have opened all of those files in the initial VU (`__VU==0`).

```javascript 
let file;

if (__VU == 0) {
  open("./file1.bin")
  open("./file2.bin")
} else if (__VU % 2 == 0) {
  file = open("./file1.bin")
} else {
  file = open("./file2.bin")
}

export default () => {
  // use file for something
}
```

## Bugs Fixed!


* We addressed an issue uncovered by [our community](https://community.k6.io/t/v0-35-0-grpc-server-reflection-error/2383), which kept our users from using GRPC with multiple services definition in a single *proto* file. This issue was solved in [#2265](https://github.com/grafana/k6/pull/2265).
* Thanks to the contribution of @Resousse, we've now updated k6's [`go-ntlmssp`](https://github.com/Azure/go-ntlmssp) dependency. The updating PR [#2290](https://github.com/grafana/k6/pull/2290) indeed fixes issues with NTLM Authentication backends returning two authorization headers. 

## Maintenance

- We have refactored our implementation of the RampingVU executor, for better clarity and maintainability. See [#2155](https://github.com/grafana/k6/pull/2155).
- [#2316](https://github.com/grafana/k6/pull/2316) relaxed quite a few of the code linting rules we applied to k6's code. It also revamped our Makefile, so the new `make ci-like-lint` target will run the exact same [golangci-lint](https://github.com/golangci/golangci-lint) version that will be used in our GitHub Actions CI pipeline.
- [#2304](https://github.com/grafana/k6/pull/2304) prepared the removal of external dependencies from k6's JSONAPI compliant REST API, and deprecated the `api.v1`'s `client.Call` method in favor of its newer `client.CallAPI` counterpart. It allows us to both reduce our reliance on external dependencies and improve its maintainability.
- We have updated our [Goja](https://github.com/dop251/goja) dependency, our JS interpreter, to its latest available version. Unfortunately, some of the new features are not always usable, yet. Namely, Goja now supports the [optional chaining](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Optional_chaining) syntax, but the Babel version we use presently does not. Which means that if Babel needs to be used, optional chaining can't be. See [#2317](https://github.com/grafana/k6/pull/2317) and [#2238](https://github.com/grafana/k6/pull/2238).
- Thanks to @knittl, [#2312](https://github.com/grafana/k6/pull/2312) upgraded [loadimpact/k6](https://hub.docker.com/r/loadimpact/k6) docker image base to Alpine *3.15*.
